/*
 * ToolSpecialConfig.h
 *
 *  Created on: 12.07.2011
 *      Author: stefan.detter
 */

#ifndef TOOLSPECIFICCONFIG_H_
#define TOOLSPECIFICCONFIG_H_

class QWidget;
class ModelData;

#include <QList>

class ToolSpecificConfig
{
public:
	ToolSpecificConfig(ModelData* modelData);
	virtual ~ToolSpecificConfig();

public:
	virtual QWidget* 	widget() = 0;
	virtual bool 		checkInput() = 0;

protected:
    QList<QString> 	availableReaderList() const;
    QList<QString> 	availableTagList() const;

private:
    ModelData* 		m_modelData;
};

#endif /* TOOLSPECIFICCONFIG_H_ */
